/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class FolioOfFanciesEffect
extends OneShotEffect {
    FolioOfFanciesEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent mills cards equal to the number of cards in their hand";
    }

    private FolioOfFanciesEffect(FolioOfFanciesEffect effect) {
        super((OneShotEffect)effect);
    }

    public FolioOfFanciesEffect copy() {
        return new FolioOfFanciesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            player.millCards(player.getHand().size(), source, game);
        }
        return true;
    }
}

