/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.IntPlusDynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityAllEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.target.Target;
import mage.target.common.TargetAnyTarget;

public final class FoodFight
extends CardImpl {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent();
    private static final DynamicValue countFoodFight;
    private static final Hint hint;
    private static final DynamicValue xValue;

    public FoodFight(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{1}{R}");
        SimpleActivatedAbility givenAbility = new SimpleActivatedAbility((Effect)new DamageTargetEffect(xValue).setText("It deals damage to any target equal to 1 plus the number of permanents named Food Fight you control"), (Cost)new GenericManaCost(2));
        givenAbility.addCost((Cost)new SacrificeSourceCost());
        givenAbility.addTarget((Target)new TargetAnyTarget());
        givenAbility.addHint(hint);
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new GainAbilityAllEffect((Ability)givenAbility, Duration.WhileOnBattlefield, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_ARTIFACTS).setText("artifacts you control have \"{2}, Sacrifice this artifact: It deals damage to any target equal to 1 plus the number of permanents named Food Fight you control.\"")));
    }

    private FoodFight(FoodFight card) {
        super((CardImpl)card);
    }

    public FoodFight copy() {
        return new FoodFight(this);
    }

    static {
        filter.add((Predicate)new NamePredicate("Food Fight"));
        countFoodFight = new PermanentsOnBattlefieldCount((FilterPermanent)filter);
        hint = new ValueHint("Food Fight you control", countFoodFight);
        xValue = new IntPlusDynamicValue(1, countFoodFight);
    }
}

