/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.StateTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class ForceBubbleStateTriggeredAbility
extends StateTriggeredAbility {
    public ForceBubbleStateTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new SacrificeSourceEffect());
    }

    private ForceBubbleStateTriggeredAbility(ForceBubbleStateTriggeredAbility ability) {
        super((StateTriggeredAbility)ability);
    }

    public ForceBubbleStateTriggeredAbility copy() {
        return new ForceBubbleStateTriggeredAbility(this);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(this.getSourceId());
        return permanent != null && permanent.getCounters(game).getCount(CounterType.DEPLETION) >= 4;
    }

    public String getRule() {
        return "When there are four or more depletion counters on {this}, sacrifice it.";
    }
}

