/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class ForceLiftReturnFromExileEffect
extends OneShotEffect {
    MageObjectReference objectToReturn;

    public ForceLiftReturnFromExileEffect(MageObjectReference objectToReturn) {
        super(Outcome.PutCardInPlay);
        this.objectToReturn = objectToReturn;
        this.staticText = "return that card to the battlefield under its owner's control";
    }

    private ForceLiftReturnFromExileEffect(ForceLiftReturnFromExileEffect effect) {
        super((OneShotEffect)effect);
        this.objectToReturn = effect.objectToReturn;
    }

    public ForceLiftReturnFromExileEffect copy() {
        return new ForceLiftReturnFromExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player owner;
        Card card = game.getCard(this.objectToReturn.getSourceId());
        if (card != null && this.objectToReturn.refersTo((MageObject)card, game) && (owner = game.getPlayer(card.getOwnerId())) != null) {
            owner.moveCards(card, Zone.BATTLEFIELD, source, game, false, false, true, null);
        }
        return true;
    }
}

