/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class ForceMasteryEffect
extends OneShotEffect {
    ForceMasteryEffect() {
        super(Outcome.DrawCard);
        this.staticText = "reveal the top card of your library and put that card into your hand. You gain life equal to its mana value";
    }

    private ForceMasteryEffect(ForceMasteryEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card = controller.getLibrary().getFromTop(game);
            if (card != null) {
                controller.revealCards(source, (Cards)new CardsImpl(card), game);
                controller.moveCards(card, Zone.HAND, source, game);
                controller.gainLife(card.getManaValue(), game, source);
            }
            return true;
        }
        return false;
    }

    public ForceMasteryEffect copy() {
        return new ForceMasteryEffect(this);
    }
}

