/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.f.ForcefieldPreventionEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.UnblockedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ForcefieldEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("an unblocked creature");

    ForcefieldEffect() {
        super(Outcome.PreventDamage);
        this.staticText = "The next time an unblocked creature of your choice would deal combat damage to you this turn, prevent all but 1 of that damage";
    }

    private ForcefieldEffect(ForcefieldEffect effect) {
        super((OneShotEffect)effect);
    }

    public ForcefieldEffect copy() {
        return new ForcefieldEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            TargetPermanent target = new TargetPermanent(1, 1, (FilterPermanent)filter, true);
            if (controller.choose(Outcome.PreventDamage, (Target)target, source, game)) {
                Permanent creature = game.getPermanent(target.getFirstTarget());
                if (creature != null) {
                    game.informPlayers(sourceObject.getLogName() + ": " + controller.getLogName() + " has chosen " + creature.getLogName());
                }
                ForcefieldPreventionEffect effect = new ForcefieldPreventionEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget(target.getFirstTarget(), game));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)UnblockedPredicate.instance);
    }
}

