/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;

class ForcefieldPreventionEffect
extends PreventionEffectImpl {
    ForcefieldPreventionEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, true, false);
        this.staticText = "Prevent all but 1 of that damage";
    }

    private ForcefieldPreventionEffect(ForcefieldPreventionEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        int damage = event.getAmount();
        if (damage > 0) {
            this.amountToPrevent = damage - 1;
            this.preventDamageAction(event, source, game);
            this.discard();
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return super.applies(event, source, game) && event.getSourceId().equals(this.getTargetPointer().getFirst(game, source));
    }

    public ForcefieldPreventionEffect copy() {
        return new ForcefieldPreventionEffect(this);
    }
}

