/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class ForensicGadgeteerEffect
extends CostModificationEffectImpl {
    private static final String effectText = "Activated abilities of artifacts you control cost {1} less to activate. This effect can't reduce the mana in that cost to less than one mana";

    public ForensicGadgeteerEffect() {
        super(Duration.Custom, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = effectText;
    }

    private ForensicGadgeteerEffect(ForensicGadgeteerEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        Player controller = game.getPlayer(abilityToModify.getControllerId());
        if (controller != null) {
            int reduceMax = CardUtil.calculateActualPossibleGenericManaReduction((Mana)abilityToModify.getManaCostsToPay().getMana(), (int)1, (int)1);
            if (reduceMax <= 0) {
                return true;
            }
            CardUtil.reduceCost((Ability)abilityToModify, (int)reduceMax);
            return true;
        }
        return false;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (abilityToModify.isActivatedAbility()) {
            Permanent permanent = game.getPermanentOrLKIBattlefield(abilityToModify.getSourceId());
            return permanent != null && permanent.isArtifact(game) && permanent.isControlledBy(source.getControllerId());
        }
        return false;
    }

    public ForensicGadgeteerEffect copy() {
        return new ForensicGadgeteerEffect(this);
    }
}

