/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ForgeOfHeroesEffect
extends OneShotEffect {
    ForgeOfHeroesEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose target commander that entered this turn. Put a +1/+1 counter on it if it's a creature and a loyalty counter on it if it's a planeswalker";
    }

    private ForgeOfHeroesEffect(ForgeOfHeroesEffect effect) {
        super((OneShotEffect)effect);
    }

    public ForgeOfHeroesEffect copy() {
        return new ForgeOfHeroesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        if (permanent.isCreature(game)) {
            permanent.addCounters(CounterType.P1P1.createInstance(), source, game);
        }
        if (permanent.isPlaneswalker(game)) {
            permanent.addCounters(CounterType.LOYALTY.createInstance(), source, game);
        }
        return true;
    }
}

