/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;

class ForgottenAncientEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterCreaturePermanent("another creature");

    ForgottenAncientEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may move any number of +1/+1 counters from {this} onto other creatures.";
    }

    private ForgottenAncientEffect(ForgottenAncientEffect effect) {
        super((OneShotEffect)effect);
    }

    public ForgottenAncientEffect copy() {
        return new ForgottenAncientEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int amountToMove;
        TargetPermanent target;
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (controller == null || sourcePermanent == null) {
            return false;
        }
        int numCounters = sourcePermanent.getCounters(game).getCount(CounterType.P1P1);
        if (numCounters == 0) {
            return false;
        }
        ArrayList<CounterMovement> counterMovements = new ArrayList<CounterMovement>();
        while ((target = new TargetPermanent(1, 1, filter, true)).canChoose(controller.getId(), source, game) && target.choose(Outcome.BoostCreature, source.getControllerId(), source.getSourceId(), source, game) && (amountToMove = controller.getAmount(0, numCounters, "Choose how many counters to move (" + numCounters + " counters remaining.)", source, game)) != 0) {
            boolean previouslyChosen = false;
            for (CounterMovement cm : counterMovements) {
                if (!cm.target.equals(target.getFirstTarget())) continue;
                cm.counters += amountToMove;
                previouslyChosen = true;
            }
            if (!previouslyChosen) {
                CounterMovement cm = new CounterMovement();
                cm.target = target.getFirstTarget();
                cm.counters = amountToMove;
                counterMovements.add(cm);
            }
            if ((numCounters -= amountToMove) > 0 && controller.chooseUse(Outcome.Benefit, "Move additional counters?", source, game)) continue;
        }
        for (CounterMovement cm : counterMovements) {
            sourcePermanent.removeCounters(CounterType.P1P1.createInstance(cm.counters), source, game);
            game.getPermanent(cm.target).addCounters(CounterType.P1P1.createInstance(cm.counters), source.getControllerId(), source, game);
        }
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }

    static class CounterMovement {
        public UUID target;
        public int counters;

        CounterMovement() {
        }
    }
}

