/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.token.ShapeshifterDeathtouchToken;
import mage.players.Player;

class FormlessGenesisEffect
extends OneShotEffect {
    FormlessGenesisEffect() {
        super(Outcome.Benefit);
        this.staticText = "create an X/X colorless Shapeshifter creature token with changeling and deathtouch, where X is the number of land cards in your graveyard";
    }

    private FormlessGenesisEffect(FormlessGenesisEffect effect) {
        super((OneShotEffect)effect);
    }

    public FormlessGenesisEffect copy() {
        return new FormlessGenesisEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int amount = Optional.ofNullable(game.getPlayer(source.getControllerId())).map(Player::getGraveyard).map(g -> g.count((FilterCard)StaticFilters.FILTER_CARD_LAND, game)).orElse(0);
        return new ShapeshifterDeathtouchToken(amount).putOntoBattlefield(1, game, source);
    }
}

