/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.ScryEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ForsakenCrossroadsEffect
extends OneShotEffect {
    ForsakenCrossroadsEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "scry 1. If you weren't the starting player, you may untap {this} instead.";
    }

    private ForsakenCrossroadsEffect(ForsakenCrossroadsEffect effect) {
        super((OneShotEffect)effect);
    }

    public ForsakenCrossroadsEffect copy() {
        return new ForsakenCrossroadsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && !controller.getId().equals(game.getStartingPlayerId()) && controller.chooseUse(Outcome.Untap, "Untap {this} instead of scrying 1?", "", "Untap", "Scry 1", source, game)) {
            Permanent permanent = source.getSourcePermanentIfItStillExists(game);
            if (permanent == null) {
                return false;
            }
            permanent.untap(game);
            return true;
        }
        ScryEffect scryEffect = new ScryEffect(1);
        scryEffect.apply(game, source);
        return true;
    }
}

