/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.DeathtouchAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.watchers.common.ManaPaidSourceWatcher;

class ForswornPaladinEffect
extends OneShotEffect {
    ForswornPaladinEffect() {
        super(Outcome.Benefit);
        this.staticText = "If mana from a Treasure was spent to activate this ability, that creature also gains deathtouch until end of turn.";
    }

    private ForswornPaladinEffect(ForswornPaladinEffect effect) {
        super((OneShotEffect)effect);
    }

    public ForswornPaladinEffect copy() {
        return new ForswornPaladinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (ManaPaidSourceWatcher.getTreasurePaid((UUID)source.getId(), (Game)game) > 0) {
            game.addEffect((ContinuousEffect)new GainAbilityTargetEffect((Ability)DeathtouchAbility.getInstance(), Duration.EndOfTurn), source);
        }
        return true;
    }
}

