/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.HashMap;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class FortunateFewEffect
extends OneShotEffect {
    FortunateFewEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Choose a nonland permanent you don't control, then each other player chooses a nonland permanent they don't control that hasn't been chosen this way. Destroy all other nonland permanents";
    }

    private FortunateFewEffect(FortunateFewEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            HashMap<Permanent, Integer> chosenCards = new HashMap<Permanent, Integer>(2);
            boolean maxCount = false;
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Permanent permanent;
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                FilterNonlandPermanent filter = new FilterNonlandPermanent("a nonland permanent you don't control");
                filter.add(Predicates.not((Predicate)new ControllerIdPredicate(player.getId())));
                for (Permanent chosenPerm : chosenCards.keySet()) {
                    filter.add(Predicates.not((Predicate)new PermanentIdPredicate(chosenPerm.getId())));
                }
                TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
                target.withNotTarget(true);
                if (!player.choose(Outcome.Exile, (Target)target, source, game) || (permanent = game.getPermanent(target.getFirstTarget())) == null) continue;
                chosenCards.put(permanent, 1);
                game.informPlayers(player.getLogName() + " has chosen: " + permanent.getName());
            }
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)new FilterNonlandPermanent(), source.getControllerId(), source, game)) {
                if (chosenCards.containsKey(permanent)) continue;
                permanent.destroy(source, game, false);
            }
            return true;
        }
        return false;
    }

    public FortunateFewEffect copy() {
        return new FortunateFewEffect(this);
    }
}

