/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FoulRenewalEffect
extends OneShotEffect {
    FoulRenewalEffect() {
        super(Outcome.Benefit);
        this.staticText = "Return target creature card from your graveyard to your hand. Target creature gets -X/-X until end of turn, where X is the toughness of the card returned this way";
    }

    private FoulRenewalEffect(FoulRenewalEffect effect) {
        super((OneShotEffect)effect);
    }

    public FoulRenewalEffect copy() {
        return new FoulRenewalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
            if (card != null) {
                int xValue = card.getToughness().getValue() * -1;
                controller.moveCards(card, Zone.HAND, source, game);
                if (xValue != 0) {
                    BoostTargetEffect effect = new BoostTargetEffect(xValue, xValue, Duration.EndOfTurn);
                    effect.setTargetPointer((TargetPointer)new FixedTarget(((Target)source.getTargets().get(1)).getFirstTarget()));
                    game.addEffect((ContinuousEffect)effect, source);
                }
            }
            return true;
        }
        return false;
    }
}

