/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FracturedIdentityEffect
extends OneShotEffect {
    FracturedIdentityEffect() {
        super(Outcome.Exile);
        this.staticText = "Exile target nonland permanent. Each player other than its controller creates a token that's a copy of it";
    }

    private FracturedIdentityEffect(FracturedIdentityEffect effect) {
        super((OneShotEffect)effect);
    }

    public FracturedIdentityEffect copy() {
        return new FracturedIdentityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (player == null || permanent == null) {
            return false;
        }
        player.moveCards((Card)permanent, Zone.EXILED, source, game);
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            if (permanent.isControlledBy(playerId)) continue;
            new CreateTokenCopyTargetEffect(playerId, null, false).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)).apply(game, source);
        }
        return true;
    }
}

