/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetSacrifice;

class FrayingOmnipotenceEffect
extends OneShotEffect {
    FrayingOmnipotenceEffect() {
        super(Outcome.Detriment);
        this.staticText = "Each player loses half their life, then discards half the cards in their hand, then sacrifices half the creatures they control. Round up each time.";
    }

    private FrayingOmnipotenceEffect(FrayingOmnipotenceEffect effect) {
        super((OneShotEffect)effect);
    }

    public FrayingOmnipotenceEffect copy() {
        return new FrayingOmnipotenceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            player = game.getPlayer(playerId);
            if (player == null) continue;
            int lifeToLose = (int)Math.ceil((double)player.getLife() / 2.0);
            player.loseLife(lifeToLose, game, source, false);
        }
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            int cardsToDiscard;
            player = game.getPlayer(playerId);
            if (player == null || (cardsToDiscard = (int)Math.ceil((double)player.getHand().size() / 2.0)) <= 0) continue;
            player.discard(cardsToDiscard, false, false, source, game);
        }
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            int creaturesToSacrifice;
            player = game.getPlayer(playerId);
            if (player == null || (creaturesToSacrifice = (int)Math.ceil((double)game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, player.getId(), source, game) / 2.0)) == 0) continue;
            TargetSacrifice target = new TargetSacrifice(creaturesToSacrifice, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE);
            target.chooseTarget(Outcome.Sacrifice, playerId, source, game);
            for (UUID permanentId : target.getTargets()) {
                Permanent permanent = game.getPermanent(permanentId);
                if (permanent == null) continue;
                permanent.sacrifice(source, game);
            }
        }
        return true;
    }
}

