/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class FrostAugurEffect
extends OneShotEffect {
    FrostAugurEffect() {
        super(Outcome.Benefit);
        this.staticText = "Look at the top card of your library. If it's a snow card, you may reveal it and put it into your hand.";
    }

    private FrostAugurEffect(FrostAugurEffect effect) {
        super((OneShotEffect)effect);
    }

    public FrostAugurEffect copy() {
        return new FrostAugurEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.lookAtCards("Top card of library", card, game);
        if (card.isSnow(game) && player.chooseUse(this.outcome, "Reveal " + card.getName() + " and put it into your hand?", source, game)) {
            player.revealCards(source, (Cards)new CardsImpl(card), game);
            player.moveCards(card, Zone.HAND, source, game);
        }
        return true;
    }
}

