/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.effects.Effect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.f.FulfillContractEffect;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetControlledPermanent;

public final class FulfillContract
extends CardImpl {
    private static final FilterCreaturePermanent filterBountyCreature = new FilterCreaturePermanent("creature with a bounty counter on it");
    private static final FilterControlledPermanent filterRogueOrHunter = new FilterControlledPermanent("Rogue or Hunter you control");

    public FulfillContract(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{B/R}{B/R}");
        this.getSpellAbility().addEffect((Effect)new FulfillContractEffect());
        this.getSpellAbility().addTarget((Target)new TargetPermanent((FilterPermanent)filterBountyCreature));
        this.getSpellAbility().addTarget((Target)new TargetControlledPermanent(filterRogueOrHunter));
    }

    private FulfillContract(FulfillContract card) {
        super((CardImpl)card);
    }

    public FulfillContract copy() {
        return new FulfillContract(this);
    }

    static {
        filterBountyCreature.add((Predicate)CounterType.BOUNTY.getPredicate());
        filterRogueOrHunter.add(Predicates.or((Predicate)SubType.ROGUE.getPredicate(), (Predicate)SubType.HUNTER.getPredicate()));
    }
}

