/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.abilities.keyword.WarpAbility;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FullBoreEffect
extends OneShotEffect {
    FullBoreEffect() {
        super(Outcome.Benefit);
        this.staticText = "If that creature was cast for its warp cost, it also gains trample and haste until end of turn";
    }

    private FullBoreEffect(FullBoreEffect effect) {
        super((OneShotEffect)effect);
    }

    public FullBoreEffect copy() {
        return new FullBoreEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null || !WarpAbility.checkIfPermanentWarped((Permanent)permanent, (Game)game)) {
            return false;
        }
        game.addEffect(new GainAbilityTargetEffect((Ability)TrampleAbility.getInstance()).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        game.addEffect(new GainAbilityTargetEffect((Ability)HasteAbility.getInstance()).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        return true;
    }
}

