/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FuriousResistanceEffect
extends OneShotEffect {
    FuriousResistanceEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Target blocking creature gets +3/+0 and gains first strike until end of turn";
    }

    private FuriousResistanceEffect(FuriousResistanceEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent target = game.getPermanent(source.getFirstTarget());
        if (target == null) {
            return false;
        }
        BoostTargetEffect effect = new BoostTargetEffect(3, 0, Duration.EndOfTurn);
        GainAbilityTargetEffect effect2 = new GainAbilityTargetEffect((Ability)FirstStrikeAbility.getInstance(), Duration.EndOfTurn);
        effect.setTargetPointer((TargetPointer)new FixedTarget(target.getId(), game));
        effect2.setTargetPointer((TargetPointer)new FixedTarget(target.getId(), game));
        game.addEffect((ContinuousEffect)effect, source);
        game.addEffect((ContinuousEffect)effect2, source);
        return true;
    }

    public FuriousResistanceEffect copy() {
        return new FuriousResistanceEffect(this);
    }
}

