/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class FurnaceBlessedConquerorEffect
extends OneShotEffect {
    FurnaceBlessedConquerorEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a tapped and attacking token that's a copy of it. Put a +1/+1 counter on that token for each +1/+1 counter on {this}. Sacrifice that token at the beginning of the next end step";
    }

    private FurnaceBlessedConquerorEffect(FurnaceBlessedConquerorEffect effect) {
        super((OneShotEffect)effect);
    }

    public FurnaceBlessedConquerorEffect copy() {
        return new FurnaceBlessedConquerorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return false;
        }
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(null, null, false, 1, true, true);
        effect.setSavedPermanent(permanent);
        effect.apply(game, source);
        effect.sacrificeTokensCreatedAtNextEndStep(game, source);
        int counters = permanent.getCounters(game).getCount(CounterType.P1P1);
        if (counters < 1) {
            return true;
        }
        for (Permanent token : effect.getAddedPermanents()) {
            token.addCounters(CounterType.P1P1.createInstance(counters), source, game);
        }
        return true;
    }
}

