/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class FuturistOperativeEffect
extends ContinuousEffectImpl {
    FuturistOperativeEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "as long as {this} is tapped, it's a Human Citizen with base power and toughness 1/1";
    }

    private FuturistOperativeEffect(FuturistOperativeEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public FuturistOperativeEffect copy() {
        return new FuturistOperativeEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || !permanent.isTapped()) {
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                permanent.removeAllSubTypes(game);
                permanent.addSubType(game, new SubType[]{SubType.HUMAN, SubType.CITIZEN});
                return true;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.SetPT_7b) break;
                permanent.getPower().setModifiedBaseValue(1);
                permanent.getToughness().setModifiedBaseValue(1);
                return true;
            }
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        switch (layer) {
            case TypeChangingEffects_4: 
            case PTChangingEffects_7: {
                return true;
            }
        }
        return false;
    }
}

