/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.replacement.ThatSpellGraveyardExileReplacementEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInOpponentsGraveyard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class JetsamEffect
extends OneShotEffect {
    JetsamEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "you may cast a spell from each opponent's graveyard without paying its mana cost. If a spell cast this way would be put into a graveyard, exile it instead.";
    }

    private JetsamEffect(JetsamEffect effect) {
        super((OneShotEffect)effect);
    }

    public JetsamEffect copy() {
        return new JetsamEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Set opponents = game.getOpponents(source.getControllerId(), true).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (controller == null || opponents.isEmpty()) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        for (Player opponent : opponents) {
            if (opponent.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_NON_LAND, game) <= 0) continue;
            TargetCardInOpponentsGraveyard target2 = new TargetCardInOpponentsGraveyard(0, 1, (FilterCard)StaticFilters.FILTER_CARD_NON_LAND, true);
            target2.withNotTarget(true);
            if (!controller.chooseTarget(this.outcome, (Cards)opponent.getGraveyard(), (TargetCard)target2, source, game)) continue;
            cards.add(game.getCard(target2.getFirstTarget()));
        }
        if (!cards.isEmpty()) {
            cards.stream().map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).map(card -> new FixedTarget(card, game)).forEach(target -> {
                ThatSpellGraveyardExileReplacementEffect effect = new ThatSpellGraveyardExileReplacementEffect(false);
                effect.setTargetPointer((TargetPointer)target);
                game.addEffect((ContinuousEffect)effect, source);
            });
            CardUtil.castMultipleWithAttributeForFree((Player)controller, (Ability)source, (Game)game, (Cards)cards, (FilterCard)StaticFilters.FILTER_CARD_NON_LAND);
        }
        return true;
    }
}

