/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageControllerEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class PlayALandTriggeredAbility
extends TriggeredAbilityImpl {
    public PlayALandTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageControllerEffect(1), false);
    }

    private PlayALandTriggeredAbility(PlayALandTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.LAND_PLAYED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return event.getPlayerId().equals(this.getControllerId());
    }

    public boolean checkInterveningIfClause(Game game) {
        Player player = game.getPlayer(this.getControllerId());
        return player != null && player.getLandsPlayed() != 1;
    }

    public PlayALandTriggeredAbility copy() {
        return new PlayALandTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever you play a land, if it wasn't the first land you played this turn, {this} deals 1 damage to you";
    }
}

