/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.game.Game;
import mage.players.Player;

enum ActivePlayerMostLandsCondition implements Condition
{
    instance;

    private static final FilterLandPermanent filter;

    public boolean apply(Game game, Ability source) {
        Player activePlayer = game.getPlayer(game.getActivePlayerId());
        if (activePlayer == null) {
            return false;
        }
        int landCount = game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, activePlayer.getId(), game).size();
        if (landCount == 0) {
            return false;
        }
        for (UUID playerId : game.getPlayerList()) {
            if (playerId.equals(activePlayer.getId()) || game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, playerId, game).size() < landCount) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "that player controls more lands than each other player";
    }

    static {
        filter = new FilterLandPermanent();
    }
}

