/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.watchers.common.AttackedLastTurnWatcher;

class CantAttackIfAttackedLastTurnEffect
extends RestrictionEffect {
    CantAttackIfAttackedLastTurnEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "{this} can't attack if it attacked during your last turn";
    }

    private CantAttackIfAttackedLastTurnEffect(CantAttackIfAttackedLastTurnEffect effect) {
        super((RestrictionEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getId().equals(source.getSourceId());
    }

    public boolean canAttack(Permanent attacker, UUID defenderId, Ability source, Game game, boolean canUseChooseDialogs) {
        AttackedLastTurnWatcher watcher = (AttackedLastTurnWatcher)game.getState().getWatcher(AttackedLastTurnWatcher.class);
        if (watcher != null) {
            MageObjectReference mor;
            Set attackingCreatures = watcher.getAttackedLastTurnCreatures(attacker.getControllerId());
            return !attackingCreatures.contains(mor = new MageObjectReference((MageObject)attacker, game));
        }
        return true;
    }

    public CantAttackIfAttackedLastTurnEffect copy() {
        return new CantAttackIfAttackedLastTurnEffect(this);
    }
}

