/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class CantBeEquippedSourceEffect
extends ContinuousRuleModifyingEffectImpl {
    private CantBeEquippedSourceEffect(CantBeEquippedSourceEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public CantBeEquippedSourceEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral);
        this.staticText = "{this} can't be equipped";
    }

    public CantBeEquippedSourceEffect copy() {
        return new CantBeEquippedSourceEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACH;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent;
        return event.getTargetId().equals(source.getSourceId()) && (permanent = game.getPermanent(event.getSourceId())) != null && permanent.hasSubtype(SubType.EQUIPMENT, game);
    }
}

