/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

enum CountersOnControlledCount implements DynamicValue
{
    instance;


    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        int count = 0;
        Permanent enchantment = game.getPermanent(sourceAbility.getSourceId());
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, sourceAbility.getControllerId(), game)) {
            if (permanent.getId().equals(enchantment.getAttachedTo())) continue;
            count += permanent.getCounters(game).getCount(CounterType.P1P1);
        }
        return count;
    }

    public CountersOnControlledCount copy() {
        return instance;
    }

    public String getMessage() {
        return "+1/+1 counter on other creatures you control";
    }

    public String toString() {
        return "X";
    }
}

