/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class GaladrielOfLothlorienEffect
extends OneShotEffect {
    GaladrielOfLothlorienEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may reveal the top card of your library. If a land card is revealed this way, put it onto the battlefield tapped";
    }

    private GaladrielOfLothlorienEffect(GaladrielOfLothlorienEffect effect) {
        super((OneShotEffect)effect);
    }

    public GaladrielOfLothlorienEffect copy() {
        return new GaladrielOfLothlorienEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.revealCards(source, (Cards)new CardsImpl(card), game);
        return card.isLand(game) && player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
    }
}

