/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.g.GarnaTheBloodflameWatcher;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class GarnaTheBloodflameEffect
extends OneShotEffect {
    GarnaTheBloodflameEffect() {
        super(Outcome.Benefit);
        this.staticText = "return to your hand all creature cards in your graveyard that were put there from anywhere this turn";
    }

    private GarnaTheBloodflameEffect(GarnaTheBloodflameEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        GarnaTheBloodflameWatcher watcher;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (watcher = (GarnaTheBloodflameWatcher)game.getState().getWatcher(GarnaTheBloodflameWatcher.class)) != null) {
            HashSet<Card> toHand = new HashSet<Card>();
            for (UUID cardId : watcher.getCardsPutToGraveyardThisTurn()) {
                Card card = game.getCard(cardId);
                if (card == null || !card.isOwnedBy(source.getControllerId()) || game.getState().getZone(cardId) != Zone.GRAVEYARD) continue;
                toHand.add(card);
            }
            if (!toHand.isEmpty()) {
                controller.moveCards(toHand, Zone.HAND, source, game);
            }
            return true;
        }
        return false;
    }

    public GarnaTheBloodflameEffect copy() {
        return new GarnaTheBloodflameEffect(this);
    }
}

