/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class GarrukRelentlessDamageEffect
extends OneShotEffect {
    GarrukRelentlessDamageEffect() {
        super(Outcome.Damage);
        this.staticText = "That creature deals damage equal to its power to him";
    }

    private GarrukRelentlessDamageEffect(GarrukRelentlessDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        Permanent creature = game.getPermanentOrLKIBattlefield(this.getTargetPointer().getFirst(game, source));
        return permanent != null && creature != null && permanent.damage(creature.getPower().getValue(), creature.getId(), source, game) > 0;
    }

    public GarrukRelentlessDamageEffect copy() {
        return new GarrukRelentlessDamageEffect(this);
    }
}

