/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.CreateTokenEvent;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.token.Token;
import mage.players.Player;

class GatherSpecimensReplacementEffect
extends ReplacementEffectImpl {
    GatherSpecimensReplacementEffect() {
        super(Duration.EndOfTurn, Outcome.GainControl);
        this.staticText = "If a creature would enter the battlefield under an opponent's control this turn, it enters under your control instead";
    }

    private GatherSpecimensReplacementEffect(GatherSpecimensReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public GatherSpecimensReplacementEffect copy() {
        return new GatherSpecimensReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE || event.getType() == GameEvent.EventType.CREATE_TOKEN;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player controller;
        Player controller2;
        Card card;
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE && ((ZoneChangeEvent)event).getToZone().match(Zone.BATTLEFIELD) && (card = game.getCard(event.getTargetId())) != null && card.isCreature(game) && (controller2 = game.getPlayer(source.getControllerId())) != null && controller2.hasOpponent(event.getPlayerId(), game)) {
            return true;
        }
        if (event.getType() == GameEvent.EventType.CREATE_TOKEN && (controller = game.getPlayer(source.getControllerId())) != null && controller.hasOpponent(event.getPlayerId(), game)) {
            for (Token token : ((CreateTokenEvent)event).getTokens().keySet()) {
                if (!token.isCreature(game)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            event.setPlayerId(controller.getId());
        }
        return false;
    }
}

