/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;

class GattaAndLuzzuEffect
extends PreventionEffectImpl {
    GattaAndLuzzuEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, false, false);
        this.staticText = "choose target creature you control. If damage would be dealt to that creature this turn, prevent that damage and put that many +1/+1 counters on it";
    }

    private GattaAndLuzzuEffect(GattaAndLuzzuEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public GattaAndLuzzuEffect copy() {
        return new GattaAndLuzzuEffect(this);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return super.applies(event, source, game) && event.getTargetId().equals(this.getTargetPointer().getFirst(game, source));
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Optional.ofNullable(this.getTargetPointer().getFirst(game, source)).map(arg_0 -> ((Game)game).getPermanent(arg_0)).ifPresent(permanent -> permanent.addCounters(CounterType.P1P1.createInstance(event.getAmount()), source, game));
        return super.replaceEvent(event, source, game);
    }
}

