/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GeistwaveEffect
extends OneShotEffect {
    GeistwaveEffect() {
        super(Outcome.Benefit);
        this.staticText = "return target nonland permanent to its owner's hand. If you controlled that permanent, draw a card";
    }

    private GeistwaveEffect(GeistwaveEffect effect) {
        super((OneShotEffect)effect);
    }

    public GeistwaveEffect copy() {
        return new GeistwaveEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player == null || permanent == null) {
            return false;
        }
        boolean flag = permanent.isControlledBy(source.getControllerId());
        player.moveCards((Card)permanent, Zone.HAND, source, game);
        if (flag) {
            player.drawCards(1, source, game);
        }
        return true;
    }
}

