/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class GeneralTazriColorCount
implements DynamicValue {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();

    GeneralTazriColorCount() {
    }

    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        int count = 0;
        boolean black = false;
        boolean red = false;
        boolean white = false;
        boolean green = false;
        boolean blue = false;
        for (Permanent creature : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, sourceAbility.getControllerId(), game)) {
            ObjectColor color = creature.getColor(game);
            black |= color.isBlack();
            red |= color.isRed();
            white |= color.isWhite();
            green |= color.isGreen();
            blue |= color.isBlue();
        }
        count += black ? 1 : 0;
        count += red ? 1 : 0;
        count += white ? 1 : 0;
        count += green ? 1 : 0;
        return count += blue ? 1 : 0;
    }

    public GeneralTazriColorCount copy() {
        return new GeneralTazriColorCount();
    }

    public String getMessage() {
        return "the number of colors among those creatures";
    }

    public String toString() {
        return "X";
    }

    static {
        filter.add((Predicate)SubType.ALLY.getPredicate());
    }
}

