/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.CreateTokenTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.TreasureToken;
import mage.target.Target;
import mage.target.common.TargetOpponent;

class GenerousPlundererEffect
extends OneShotEffect {
    GenerousPlundererEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may create a Treasure token. When you do, target opponent creates a tapped Treasure token.";
    }

    private GenerousPlundererEffect(GenerousPlundererEffect effect) {
        super((OneShotEffect)effect);
    }

    public GenerousPlundererEffect copy() {
        return new GenerousPlundererEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean flag = new CreateTokenEffect((Token)new TreasureToken()).apply(game, source);
        if (!flag) {
            return false;
        }
        ReflexiveTriggeredAbility reflexive = new ReflexiveTriggeredAbility((Effect)new CreateTokenTargetEffect((Token)new TreasureToken(), 1, true), false);
        reflexive.addTarget((Target)new TargetOpponent());
        game.fireReflexiveTriggeredAbility(reflexive, source);
        return true;
    }
}

