/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.DealsDamageSourceTriggeredAbility;
import mage.abilities.common.DiesAttachedTriggeredAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.SavedDamageValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.abilities.effects.common.ReturnToHandSourceEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureAttachedWithActivatedAbilityOrSpellEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.TokenImpl;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class GenjuOfTheFields
extends CardImpl {
    private static final FilterPermanent FILTER = new FilterPermanent(SubType.PLAINS, "Plains");

    public GenjuOfTheFields(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{W}");
        this.subtype.add((Object)SubType.AURA);
        TargetPermanent auraTarget = new TargetPermanent(FILTER);
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.PutCreatureInPlay));
        this.addAbility((Ability)new EnchantAbility((Target)auraTarget));
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new BecomesCreatureAttachedWithActivatedAbilityOrSpellEffect((Token)new SpiritToken(), "Until end of turn, enchanted Plains becomes a 2/5 white Spirit creature", Duration.EndOfTurn), (Cost)new GenericManaCost(2));
        ability.addEffect((Effect)new GainAbilityAttachedEffect((Ability)new DealsDamageSourceTriggeredAbility((Effect)new GainLifeEffect((DynamicValue)SavedDamageValue.MUCH)), AttachmentType.AURA, Duration.EndOfTurn).setText("with \"Whenever this creature deals damage, its controller gains that much life.\" It's still a land"));
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new DiesAttachedTriggeredAbility((Effect)new ReturnToHandSourceEffect(false, true).setText("you may return {this} from your graveyard to your hand"), "enchanted Plains", true, false));
    }

    private GenjuOfTheFields(GenjuOfTheFields card) {
        super((CardImpl)card);
    }

    public GenjuOfTheFields copy() {
        return new GenjuOfTheFields(this);
    }

    private static class SpiritToken
    extends TokenImpl {
        SpiritToken() {
            super("Spirit", "2/5 white Spirit creature");
            this.cardType.add(CardType.CREATURE);
            this.color.setWhite(true);
            this.subtype.add((Object)SubType.SPIRIT);
            this.power = new MageInt(2);
            this.toughness = new MageInt(5);
        }

        private SpiritToken(SpiritToken token) {
            super((TokenImpl)token);
        }

        public SpiritToken copy() {
            return new SpiritToken(this);
        }
    }
}

