/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.cards.g.GeralfTheFleshwrightWatcher;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class GeralfTheFleshwrightEffect
extends OneShotEffect {
    GeralfTheFleshwrightEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "put a +1/+1 counter on it for each other Zombie that entered the battlefield under your control this turn";
    }

    private GeralfTheFleshwrightEffect(GeralfTheFleshwrightEffect effect) {
        super((OneShotEffect)effect);
    }

    public GeralfTheFleshwrightEffect copy() {
        return new GeralfTheFleshwrightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        GeralfTheFleshwrightWatcher watcher = (GeralfTheFleshwrightWatcher)game.getState().getWatcher(GeralfTheFleshwrightWatcher.class);
        if (watcher == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        int count = watcher.getZombiesThatEnteredThisTurn(source.getControllerId(), new MageObjectReference((MageObject)permanent, game));
        if (count > 0) {
            new AddCountersTargetEffect(CounterType.P1P1.createInstance(count)).setTargetPointer(this.getTargetPointer().copy()).apply(game, source);
        }
        return true;
    }
}

