/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.card.PutIntoGraveFromBattlefieldThisTurnPredicate;
import mage.game.Game;
import mage.players.Player;

class GerrardWeatherlightHeroEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard();

    GerrardWeatherlightHeroEffect() {
        super(Outcome.Benefit);
        this.staticText = "and return to the battlefield all artifact and creature cards in your graveyard that were put there from the battlefield this turn";
    }

    private GerrardWeatherlightHeroEffect(GerrardWeatherlightHeroEffect effect) {
        super((OneShotEffect)effect);
    }

    public GerrardWeatherlightHeroEffect copy() {
        return new GerrardWeatherlightHeroEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        return player.moveCards(player.getGraveyard().getCards(filter, source.getControllerId(), source, game), Zone.BATTLEFIELD, source, game);
    }

    static {
        filter.add((Predicate)PutIntoGraveFromBattlefieldThisTurnPredicate.instance);
        filter.add(Predicates.or((Predicate)CardType.ARTIFACT.getPredicate(), (Predicate)CardType.CREATURE.getPredicate()));
    }
}

