/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.card.PutIntoGraveFromBattlefieldThisTurnPredicate;
import mage.game.Game;
import mage.players.Player;

class GerrardsHourglassPendantReanimateEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard();

    GerrardsHourglassPendantReanimateEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Return to the battlefield tapped all artifact, creature, enchantment, and land cards in your graveyard that were put there from the battlefield this turn";
    }

    private GerrardsHourglassPendantReanimateEffect(GerrardsHourglassPendantReanimateEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        return player.moveCards(player.getGraveyard().getCards(filter, source.getControllerId(), source, game), Zone.BATTLEFIELD, source, game, true, false, false, null);
    }

    public GerrardsHourglassPendantReanimateEffect copy() {
        return new GerrardsHourglassPendantReanimateEffect(this);
    }

    static {
        filter.add((Predicate)PutIntoGraveFromBattlefieldThisTurnPredicate.instance);
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.CREATURE.getPredicate(), CardType.ENCHANTMENT.getPredicate(), CardType.LAND.getPredicate()}));
    }
}

