/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.HashMap;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class GerrymanderingEffect
extends OneShotEffect {
    GerrymanderingEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile all lands. Give each player a number of those cards chosen at random equal to the number of those cards the player controlled. Each player returns those cards to the battlefield under their control";
    }

    private GerrymanderingEffect(GerrymanderingEffect effect) {
        super((OneShotEffect)effect);
    }

    public GerrymanderingEffect copy() {
        return new GerrymanderingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashMap<UUID, Integer> playerLandCount = new HashMap<UUID, Integer>();
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CardsImpl exiledCards = new CardsImpl();
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_LANDS, source.getControllerId(), source, game)) {
                exiledCards.add((Card)permanent);
                playerLandCount.putIfAbsent(permanent.getControllerId(), 0);
                playerLandCount.put(permanent.getControllerId(), (Integer)playerLandCount.get(permanent.getControllerId()) + 1);
                controller.moveCardsToExile((Card)permanent, source, game, true, CardUtil.getCardExileZoneId((Game)game, (UUID)source.getSourceId()), "Gerrymandering");
            }
            block1: for (UUID playerId : playerLandCount.keySet()) {
                if (exiledCards.isEmpty()) break;
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                for (int i = 1; i <= (Integer)playerLandCount.get(playerId); ++i) {
                    Card card = exiledCards.getRandom(game);
                    exiledCards.remove(card);
                    player.moveCards(card, Zone.BATTLEFIELD, source, game, false, false, false, null);
                    if (exiledCards.isEmpty()) continue block1;
                }
            }
            return true;
        }
        return false;
    }
}

