/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.watchers.common.PlayerLostLifeWatcher;

class GevScaledScorchEntersEffect
extends ReplacementEffectImpl {
    GevScaledScorchEntersEffect() {
        super(Duration.WhileOnBattlefield, Outcome.BoostCreature);
        this.staticText = "Other creatures you control enter with an additional +1/+1 counter on them for each opponent who lost life this turn";
    }

    private GevScaledScorchEntersEffect(GevScaledScorchEntersEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent creature = ((EntersTheBattlefieldEvent)event).getTarget();
        return creature != null && creature.isControlledBy(source.getControllerId()) && creature.isCreature(game) && !event.getTargetId().equals(source.getSourceId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent creature = ((EntersTheBattlefieldEvent)event).getTarget();
        Player controller = game.getPlayer(source.getControllerId());
        PlayerLostLifeWatcher watcher = (PlayerLostLifeWatcher)game.getState().getWatcher(PlayerLostLifeWatcher.class);
        if (creature == null || controller == null || watcher == null) {
            return false;
        }
        int num = game.getOpponents(controller.getId()).stream().mapToInt(arg_0 -> ((PlayerLostLifeWatcher)watcher).getLifeLost(arg_0)).map(x -> x > 0 ? 1 : 0).sum();
        if (num > 0) {
            creature.addCounters(CounterType.P1P1.createInstance(num), source.getControllerId(), source, game);
        }
        return false;
    }

    public GevScaledScorchEntersEffect copy() {
        return new GevScaledScorchEntersEffect(this);
    }
}

