/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GhastlyDemiseEffect
extends OneShotEffect {
    GhastlyDemiseEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "destroy target nonblack creature if its toughness is less than or equal to the number of cards in your graveyard";
    }

    private GhastlyDemiseEffect(GhastlyDemiseEffect effect) {
        super((OneShotEffect)effect);
    }

    public GhastlyDemiseEffect copy() {
        return new GhastlyDemiseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        Player player = game.getPlayer(source.getControllerId());
        return permanent != null && player != null && permanent.getToughness().getValue() <= player.getGraveyard().size() && permanent.destroy(source, game);
    }
}

