/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GhastlyMimicryEffect
extends OneShotEffect {
    GhastlyMimicryEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a token that's a copy of enchanted creature, except it's a Spirit in addition to its other types";
    }

    private GhastlyMimicryEffect(GhastlyMimicryEffect effect) {
        super((OneShotEffect)effect);
    }

    public GhastlyMimicryEffect copy() {
        return new GhastlyMimicryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (permanent == null) {
            return false;
        }
        Permanent attached = game.getPermanent(permanent.getAttachedTo());
        if (attached == null) {
            return false;
        }
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect();
        effect.withAdditionalSubType(SubType.SPIRIT);
        return effect.setTargetPointer((TargetPointer)new FixedTarget(attached, game)).apply(game, source);
    }
}

