/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.HashSet;
import java.util.Set;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.PopulateEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

class GhiredsBelligerenceDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    private final Set<MageObjectReference> referenceSet = new HashSet<MageObjectReference>();

    GhiredsBelligerenceDelayedTriggeredAbility(Set<MageObjectReference> referenceSet) {
        super((Effect)new PopulateEffect(), Duration.EndOfTurn, false);
        this.referenceSet.addAll(referenceSet);
    }

    private GhiredsBelligerenceDelayedTriggeredAbility(GhiredsBelligerenceDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.referenceSet.addAll(ability.referenceSet);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return zEvent.isDiesEvent() && this.referenceSet.stream().anyMatch(mor -> mor.refersTo((MageObject)zEvent.getTarget(), game));
    }

    public GhiredsBelligerenceDelayedTriggeredAbility copy() {
        return new GhiredsBelligerenceDelayedTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever a creature dealt damage this way dies this turn, populate.";
    }
}

