/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageMultiEffect;
import mage.cards.g.GhiredsBelligerenceDelayedTriggeredAbility;
import mage.constants.Outcome;
import mage.game.Game;

class GhiredsBelligerenceEffect
extends OneShotEffect {
    private static final DamageMultiEffect effect = new DamageMultiEffect();

    GhiredsBelligerenceEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals X damage divided as you choose among any number of target creatures. Whenever a creature dealt damage this way dies this turn, populate.";
    }

    private GhiredsBelligerenceEffect(GhiredsBelligerenceEffect effect) {
        super((OneShotEffect)effect);
    }

    public GhiredsBelligerenceEffect copy() {
        return new GhiredsBelligerenceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (!effect.apply(game, source)) {
            return false;
        }
        if (effect.getDamagedSet().isEmpty()) {
            return true;
        }
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new GhiredsBelligerenceDelayedTriggeredAbility(effect.getDamagedSet()), source);
        return true;
    }
}

