/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class GhostlyPilfererTriggeredAbility
extends TriggeredAbilityImpl {
    GhostlyPilfererTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1), false);
    }

    private GhostlyPilfererTriggeredAbility(GhostlyPilfererTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public GhostlyPilfererTriggeredAbility copy() {
        return new GhostlyPilfererTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell = game.getStack().getSpell(event.getTargetId());
        return game.getOpponents(this.getControllerId()).contains(spell.getControllerId()) && event.getZone() != Zone.HAND;
    }

    public String getRule() {
        return "Whenever an opponent casts a spell from anywhere other than their hand, draw a card.";
    }
}

