/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.RemoveDelayedTriggeredAbilityEffect;
import mage.abilities.effects.common.counter.RemoveAllCountersPermanentTargetEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

class GiantOysterLeaveUntapDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    public GiantOysterLeaveUntapDelayedTriggeredAbility(UUID abilityToCancel) {
        super((Effect)new RemoveAllCountersPermanentTargetEffect(CounterType.M1M1), Duration.EndOfGame, true, false);
        this.addEffect((Effect)new RemoveDelayedTriggeredAbilityEffect(abilityToCancel));
    }

    private GiantOysterLeaveUntapDelayedTriggeredAbility(GiantOysterLeaveUntapDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType().equals((Object)GameEvent.EventType.UNTAPPED) || event.getType().equals((Object)GameEvent.EventType.ZONE_CHANGE);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getType().equals((Object)GameEvent.EventType.UNTAPPED) && event.getTargetId() != null && event.getTargetId().equals(this.getSourceId())) {
            return true;
        }
        return event.getType().equals((Object)GameEvent.EventType.ZONE_CHANGE) && event.getTargetId() != null && event.getTargetId().equals(this.getSourceId()) && ((ZoneChangeEvent)event).getFromZone() == Zone.BATTLEFIELD;
    }

    public GiantOysterLeaveUntapDelayedTriggeredAbility copy() {
        return new GiantOysterLeaveUntapDelayedTriggeredAbility(this);
    }

    public String getRule() {
        return "When {this} leaves the battlefield or becomes untapped, remove all -1/-1 counters from the creature.";
    }
}

