/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.RequirementEffect;
import mage.constants.Duration;
import mage.constants.TurnPhase;
import mage.game.Game;
import mage.game.permanent.Permanent;

class GideonJuraEffect
extends RequirementEffect {
    protected MageObjectReference creatingPermanent;

    public GideonJuraEffect() {
        super(Duration.Custom);
        this.staticText = "During target opponent's next turn, creatures that player controls attack {this} if able";
    }

    private GideonJuraEffect(GideonJuraEffect effect) {
        super((RequirementEffect)effect);
        this.creatingPermanent = effect.creatingPermanent;
    }

    public GideonJuraEffect copy() {
        return new GideonJuraEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.creatingPermanent = new MageObjectReference(source.getSourceId(), game);
        this.setStartingControllerAndTurnNum(game, source.getFirstTarget(), game.getActivePlayerId());
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.isControlledBy(source.getFirstTarget()) && this.isYourNextTurn(game);
    }

    public boolean isInactive(Ability source, Game game) {
        return game.getTurnPhaseType() == TurnPhase.END && this.isYourNextTurn(game) || this.creatingPermanent.getPermanent(game) == null;
    }

    public UUID mustAttackDefender(Ability source, Game game) {
        return source.getSourceId();
    }

    public boolean mustAttack(Game game) {
        return true;
    }

    public boolean mustBlock(Game game) {
        return false;
    }
}

